
unit WebForm8;

interface

uses
  SysUtils, System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls;

type
  TWebForm8 = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
		procedure btnAddReview_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
		TopHolder: System.Web.UI.WebControls.PlaceHolder;
		CategoriesHolder: System.Web.UI.WebControls.PlaceHolder;
		MyError: System.Web.UI.WebControls.Label;
		RequiredFieldValidator1: System.Web.UI.WebControls.RequiredFieldValidator;
		Name: System.Web.UI.WebControls.TextBox;
		RegularExpressionValidator1: System.Web.UI.WebControls.RegularExpressionValidator;
		RequiredFieldValidator2: System.Web.UI.WebControls.RequiredFieldValidator;
		Email: System.Web.UI.WebControls.TextBox;
		Comment: System.Web.UI.WebControls.TextBox;
		rbOcjena: System.Web.UI.WebControls.RadioButtonList;
		btnAddReview: System.Web.UI.WebControls.Button;
		topicHeading: System.Web.UI.WebControls.Label;
		topicDescription: System.Web.UI.WebControls.Label;
    procedure OnInit(e: EventArgs); override;
  end;

implementation


uses top, apptypes, productsDB;

var _top : CSTop;
    _AppTypes : csAppTypes;
    PID : string;

procedure TWebForm8.Page_Load(sender: System.Object; e: System.EventArgs);
begin
  // Put user code to initialize the page here

  			topicHeading.Text:='Example review :: ' + Request.QueryString.Get('PName');
			topicDescription.Text:='Add your own view/comment to this example!';

			PID := Request.QueryString.Get('ID');
			
			if PID = '' then
			begin
				MyError.Text:='Error. Example ID not found!';
				//btnAddReview.enabled:=False;
			end;
end;

procedure TWebForm8.OnInit(e: EventArgs);
begin
  //
  // CODEGEN: This call is required by the ASP.NET Web Form Designer.
  //
  InitializeComponent;
  inherited OnInit(e);

      _AppTypes := csAppTypes.create;
      CategoriesHolder.Controls.Add(_AppTypes);
      _AppTypes.Free;

      _top := CSTop.create;
      TopHolder.Controls.Add(_top);
      _top.Free;
end;

procedure TWebForm8.btnAddReview_Click(sender: System.Object; e: System.EventArgs);
var
  ReviewID : integer;
  Review : TproductsDB;
begin
  if not Page.IsValid = true Then Exit;

  Review:=TproductsDB.Create;
  ReviewID:=Review.AddProductReview(StrToInt(PID), 1 + rbOcjena.SelectedIndex, Name.Text, Email.Text, Comment.Text);

  if ReviewID <> 0 then
  begin
    Response.Redirect('webform1.aspx?id='+ PID);
  end
  else
     MyError.Text := 'Review insert failed!';
end;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWebForm8.InitializeComponent;
begin
	Include(Self.btnAddReview.Click, Self.btnAddReview_Click);
	Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}


end.

